/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.comm;

import java.util.HashMap;
import java.util.Map;

public enum ProgramStateMessageType {
    GLOBAL_VARIABLES_SETUP(0),
    GLOBAL_VARIABLES_UPDATE(1),
    VARIABLE_UPDATE(2);

    private static final Map<Integer, ProgramStateMessageType> idCache;
    private int id;

    private ProgramStateMessageType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ProgramStateMessageType byId(int id) {
        if (idCache.isEmpty()) {
            ProgramStateMessageType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ProgramStateMessageType with id " + id + " supported!");
        return ProgramStateMessageType.values()[0];
    }

    private static void buildCache() {
        for (ProgramStateMessageType each : ProgramStateMessageType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ProgramStateMessageType>();
    }
}

