/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.comm;

import java.util.HashMap;
import java.util.Map;

public enum RequestValueType {
    BOOLEAN(0),
    INTEGER(1),
    FLOAT(2),
    STRING(3),
    POSE(4),
    JOINTVECTOR(5),
    WAYPOINT(6),
    EXPRESSION(7),
    NONE(8);

    private static final Map<Integer, RequestValueType> idCache;
    private int id;

    private RequestValueType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static RequestValueType byId(int id) {
        if (idCache.isEmpty()) {
            RequestValueType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No RequestValueType with id " + id + " supported!");
        return RequestValueType.values()[0];
    }

    private static void buildCache() {
        for (RequestValueType each : RequestValueType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, RequestValueType>();
    }
}

