/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.comm;

import java.util.HashMap;
import java.util.Map;

public enum RobotMessageType {
    TEXT(0),
    PROGRAM_LABEL(1),
    POPUP(2),
    VERSION(3),
    UNDEFINED(4),
    SAFETY_MODE(5),
    ERROR_CODE(6),
    KEY(7),
    REQUEST_VALUE(9),
    RUNTIME_EXCEPTION(10),
    FIRMWARE_UPDATE_STATUS(11),
    SAFETY_VERSION(12),
    RTDE(13),
    PROGRAM_LABEL_THREADS(14),
    BREAKPOINT_HIT(15),
    THREAD_TIMES(16),
    URCONTROL_INFO(17);

    private static final Map<Integer, RobotMessageType> idCache;
    private int id;

    private RobotMessageType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static RobotMessageType byId(int id) {
        if (idCache.isEmpty()) {
            RobotMessageType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No RobotMessageType with id " + id + " supported!");
        return RobotMessageType.values()[0];
    }

    private static void buildCache() {
        for (RobotMessageType each : RobotMessageType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, RobotMessageType>();
    }
}

