/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.comm;

import java.util.HashMap;
import java.util.Map;

public enum RobotStatePackageType {
    ROBOT_MODE_DATA(0),
    JOINT_DATA(1),
    TOOL_DATA(2),
    MASTERBOARD_DATA(3),
    CARTESIAN_INFO(4),
    KINEMATICS_INFO(5),
    CONFIGURATION_DATA(6),
    FORCE_MODE_DATA(7),
    ADDITIONAL_INFO(8),
    NEEDED_FOR_CALIB_DATA(9),
    SAFETY_DATA(10),
    TOOL_COMM_INFO(11),
    TOOL_OUTPUT_INFO(12),
    SINGULARITY_INFO(13),
    ACTIVE_PAYLOAD(14),
    INTERNAL_DATA(15),
    CUMULATIVE_RUNTIME_DATA(16);

    private static final Map<Integer, RobotStatePackageType> idCache;
    private int id;

    private RobotStatePackageType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static RobotStatePackageType byId(int id) {
        if (idCache.isEmpty()) {
            RobotStatePackageType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No RobotStatePackageType with id " + id + " supported!");
        return RobotStatePackageType.values()[0];
    }

    private static void buildCache() {
        for (RobotStatePackageType each : RobotStatePackageType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, RobotStatePackageType>();
    }
}

