/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum CalibrationStatus {
    NOT_INITIALIZED(0),
    NOT_LINEARIZED(1),
    LINEARIZED(2),
    APPLY_ONLY_IN_MEMORY(3);

    private static final Map<Integer, CalibrationStatus> idCache;
    private int id;

    private CalibrationStatus(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static CalibrationStatus byId(int id) {
        if (idCache.isEmpty()) {
            CalibrationStatus.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No CalibrationStatus with id " + id + " supported!");
        return CalibrationStatus.values()[0];
    }

    private static void buildCache() {
        for (CalibrationStatus each : CalibrationStatus.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, CalibrationStatus>();
    }
}

