/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum JointMode {
    RESET(235),
    SHUTTING_DOWN(236),
    PART_D_CALIBRATION(237),
    BACKDRIVE(238),
    POWER_OFF(239),
    READY_FOR_POWER_OFF(240),
    NOT_RESPONDING(245),
    MOTOR_INITIALISATION(246),
    BOOTING(247),
    PART_D_CALIBRATION_ERROR(248),
    BOOTLOADER(249),
    CALIBRATION(250),
    VIOLATION(251),
    FAULT(252),
    RUNNING(253),
    BRAKE_FAILURE(254),
    IDLE(255);

    private static final Map<Integer, JointMode> idCache;
    private int id;

    private JointMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static JointMode byId(int id) {
        if (idCache.isEmpty()) {
            JointMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No JointMode with id " + id + " supported!");
        return JointMode.values()[0];
    }

    private static void buildCache() {
        for (JointMode each : JointMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, JointMode>();
    }
}

