/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum JointType {
    UNDEFINED(-1),
    BASE(0),
    SHOULDER(1),
    ELBOW(2),
    WRIST1(3),
    WRIST2(4),
    WRIST3(5);

    private static final Map<Integer, JointType> idCache;
    private int id;

    private JointType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static JointType byId(int id) {
        if (idCache.isEmpty()) {
            JointType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No JointType with id " + id + " supported!");
        return JointType.values()[0];
    }

    private static void buildCache() {
        for (JointType each : JointType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, JointType>();
    }
}

