/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum OperationalMode {
    DISABLED(0),
    AUTOMATIC(1),
    MANUAL(2);

    private static final Map<Integer, OperationalMode> idCache;
    private int id;

    private OperationalMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static OperationalMode byId(int id) {
        if (idCache.isEmpty()) {
            OperationalMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No OperationalMode with id " + id + " supported!");
        return OperationalMode.values()[0];
    }

    private static void buildCache() {
        for (OperationalMode each : OperationalMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, OperationalMode>();
    }
}

