/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum RobotMode {
    NO_CONTROLLER(-1),
    DISCONNECTED(0),
    CONFIRM_SAFETY(1),
    BOOTING(2),
    POWER_OFF(3),
    POWER_ON(4),
    IDLE(5),
    BACKDRIVE(6),
    RUNNING(7),
    UPDATING(8),
    POWERING_OFF(9),
    ARM_BOOTING(10),
    ARM_UPDATING(11);

    private static final Map<Integer, RobotMode> idCache;
    private int id;

    private RobotMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static RobotMode byId(int id) {
        if (idCache.isEmpty()) {
            RobotMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No RobotMode with id " + id + " supported!");
        return RobotMode.values()[0];
    }

    private static void buildCache() {
        for (RobotMode each : RobotMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, RobotMode>();
    }
}

