/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum SafetyMode {
    NORMAL(1),
    REDUCED(2),
    PROTECTIVE_STOP(3),
    RECOVERY(4),
    SAFEGUARD_STOP(5),
    SYSTEM_EMERGENCY_STOP(6),
    ROBOT_EMERGENCY_STOP(7),
    VIOLATION(8),
    FAULT(9),
    VALIDATE_JOINT_ID(10),
    UNDEFINED_SAFETY_MODE(11),
    AUTOMATIC_MODE_SAFEGUARD_STOP(12),
    SYSTEM_THREE_POSITION_ENABLING_STOP(13),
    TP_THREE_POSITION_ENABLING_STOP(14),
    IMMI_EMERGENCY_STOP(15),
    IMMI_SAFEGUARD_STOP(16),
    PROFISAFE_WAITING_FOR_PARAMETERS(17),
    PROFISAFE_AUTOMATIC_MODE_SAFEGUARD_STOP(18),
    PROFISAFE_SAFEGUARD_STOP(19),
    PROFISAFE_EMERGENCY_STOP(20),
    BRAKE_PIN_FAILURE(21),
    SAFETY_API_SAFEGUARD_STOP(22),
    SAFETY_PLANES_SAFEGUARD_STOP(23);

    private static final Map<Integer, SafetyMode> idCache;
    private int id;

    private SafetyMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static SafetyMode byId(int id) {
        if (idCache.isEmpty()) {
            SafetyMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No SafetyMode with id " + id + " supported!");
        return SafetyMode.values()[0];
    }

    private static void buildCache() {
        for (SafetyMode each : SafetyMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, SafetyMode>();
    }
}

