/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum TPButtonState {
    RELEASED(0),
    PRESSED(1),
    CLICKED_AND_PRESSED(2);

    private static final Map<Integer, TPButtonState> idCache;
    private int id;

    private TPButtonState(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static TPButtonState byId(int id) {
        if (idCache.isEmpty()) {
            TPButtonState.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No TPButtonState with id " + id + " supported!");
        return TPButtonState.values()[0];
    }

    private static void buildCache() {
        for (TPButtonState each : TPButtonState.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, TPButtonState>();
    }
}

