/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum TPType {
    NONE(0),
    STANDARD(1),
    THREE_POSITION_ENABLING(2);

    private static final Map<Integer, TPType> idCache;
    private int id;

    private TPType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static TPType byId(int id) {
        if (idCache.isEmpty()) {
            TPType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No TPType with id " + id + " supported!");
        return TPType.values()[0];
    }

    private static void buildCache() {
        for (TPType each : TPType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, TPType>();
    }
}

