/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum ToolAnalogInputMode {
    VOLTAGE(0),
    CURRENT(1);

    private static final Map<Integer, ToolAnalogInputMode> idCache;
    private int id;

    private ToolAnalogInputMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ToolAnalogInputMode byId(int id) {
        if (idCache.isEmpty()) {
            ToolAnalogInputMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ToolAnalogInputMode with id " + id + " supported!");
        return ToolAnalogInputMode.values()[0];
    }

    private static void buildCache() {
        for (ToolAnalogInputMode each : ToolAnalogInputMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ToolAnalogInputMode>();
    }
}

