/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum ToolDigitalOutputMode {
    DISABLED(0),
    SINKING(1),
    SOURCING(2),
    PUSH_PULL(3);

    private static final Map<Integer, ToolDigitalOutputMode> idCache;
    private int id;

    private ToolDigitalOutputMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ToolDigitalOutputMode byId(int id) {
        if (idCache.isEmpty()) {
            ToolDigitalOutputMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ToolDigitalOutputMode with id " + id + " supported!");
        return ToolDigitalOutputMode.values()[0];
    }

    private static void buildCache() {
        for (ToolDigitalOutputMode each : ToolDigitalOutputMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ToolDigitalOutputMode>();
    }
}

