/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum ToolInputMode {
    ANALOG(0),
    DATA(1);

    private static final Map<Integer, ToolInputMode> idCache;
    private int id;

    private ToolInputMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ToolInputMode byId(int id) {
        if (idCache.isEmpty()) {
            ToolInputMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ToolInputMode with id " + id + " supported!");
        return ToolInputMode.values()[0];
    }

    private static void buildCache() {
        for (ToolInputMode each : ToolInputMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ToolInputMode>();
    }
}

