/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum ToolOutputMode {
    OUTPUT(0),
    POWER(1),
    SAFE(2);

    private static final Map<Integer, ToolOutputMode> idCache;
    private int id;

    private ToolOutputMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ToolOutputMode byId(int id) {
        if (idCache.isEmpty()) {
            ToolOutputMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ToolOutputMode with id " + id + " supported!");
        return ToolOutputMode.values()[0];
    }

    private static void buildCache() {
        for (ToolOutputMode each : ToolOutputMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ToolOutputMode>();
    }
}

