/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev;

import java.util.HashMap;
import java.util.Map;

public enum ToolPowerMode {
    PSU_OFF(0),
    PSU_12V(2),
    PSU_24V(3);

    private static final Map<Integer, ToolPowerMode> idCache;
    private int id;

    private ToolPowerMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ToolPowerMode byId(int id) {
        if (idCache.isEmpty()) {
            ToolPowerMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ToolPowerMode with id " + id + " supported!");
        return ToolPowerMode.values()[0];
    }

    private static void buildCache() {
        for (ToolPowerMode each : ToolPowerMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ToolPowerMode>();
    }
}

