/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev.robotsize;

import java.util.HashMap;
import java.util.Map;

public enum JointSize {
    NULL(-1),
    SIZE0(0),
    SIZE1(1),
    SIZE2(2),
    SIZE3(3),
    SIZE4(4),
    SIZE5(5),
    SIZE2_5(6),
    SIZE4_V2(7),
    COUNT(8);

    private static final Map<Integer, JointSize> idCache;
    private int id;

    private JointSize(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static JointSize byId(int id) {
        if (idCache.isEmpty()) {
            JointSize.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No JointSize with id " + id + " supported!");
        return JointSize.values()[0];
    }

    private static void buildCache() {
        for (JointSize each : JointSize.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, JointSize>();
    }
}

