/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.dev.robotsize;

import java.util.HashMap;
import java.util.Map;

public enum RobotType {
    UNDEFINED(0),
    UR5(1),
    UR10(2),
    UR3(3),
    UR16(4),
    UR18(5),
    UR8_LONG(6),
    UR20(7),
    UR30(8),
    UR15(9),
    HW_TEST(167);

    private static final Map<Integer, RobotType> idCache;
    private int id;

    private RobotType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static RobotType byId(int id) {
        if (idCache.isEmpty()) {
            RobotType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No RobotType with id " + id + " supported!");
        return RobotType.values()[0];
    }

    private static void buildCache() {
        for (RobotType each : RobotType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, RobotType>();
    }
}

