/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.errorcodes;

import java.util.HashMap;
import java.util.Map;

public enum MessageSource {
    UNDEFINED(-1),
    JOINT_0(0),
    JOINT_1(1),
    JOINT_2(2),
    JOINT_3(3),
    JOINT_4(4),
    JOINT_5(5),
    TOOL(6),
    EUROMAP_2(68),
    EUROMAP_1(67),
    TEACH_PENDANT_2(66),
    TEACH_PENDANT_1(65),
    JOINT_0_FPGA(100),
    JOINT_0_A(110),
    JOINT_0_B(120),
    JOINT_1_FPGA(101),
    JOINT_1_A(111),
    JOINT_1_B(121),
    JOINT_2_FPGA(102),
    JOINT_2_A(112),
    JOINT_2_B(122),
    JOINT_3_FPGA(103),
    JOINT_3_A(113),
    JOINT_3_B(123),
    JOINT_4_FPGA(104),
    JOINT_4_A(114),
    JOINT_4_B(124),
    JOINT_5_FPGA(105),
    JOINT_5_A(115),
    JOINT_5_B(125),
    TOOL_FPGA(106),
    TOOL_A(116),
    TOOL_B(126),
    IMMI_FPGA(107),
    IMMI_A(117),
    IMMI_B(127),
    TEACH_PENDANT_A(108),
    TEACH_PENDANT_B(118),
    BFB_FPGA(109),
    BFB_A(119),
    BFB_B(129),
    ExtenderNear_FPGA(70),
    ExtenderNear_MCU(71),
    ExtenderFar_FPGA(72),
    ExtenderFar_MCU(73),
    SCB_FPGA(40),
    UA(20),
    UB(30),
    ROBOTINTERFACE(-2),
    RTMACHINE(-3),
    SIMULATED_ROBOT(-4),
    GUI(-5),
    CONTROLLER(7),
    RTDE(8);

    private static final Map<Integer, MessageSource> idCache;
    private int id;

    private MessageSource(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static MessageSource byId(int id) {
        if (idCache.isEmpty()) {
            MessageSource.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No MessageSource with id " + id + " supported!");
        return MessageSource.values()[0];
    }

    private static void buildCache() {
        for (MessageSource each : MessageSource.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, MessageSource>();
    }
}

