/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.errorcodes;

import java.util.HashMap;
import java.util.Map;

public enum ReportDataType {
    NONE(0),
    UNSIGNED(1),
    SIGNED(2),
    FLOAT(3),
    HEXADECIMAL(4),
    STRING(5);

    private static final Map<Integer, ReportDataType> idCache;
    private int id;

    private ReportDataType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ReportDataType byId(int id) {
        if (idCache.isEmpty()) {
            ReportDataType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ReportDataType with id " + id + " supported!");
        return ReportDataType.values()[0];
    }

    private static void buildCache() {
        for (ReportDataType each : ReportDataType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ReportDataType>();
    }
}

