/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.errorcodes;

import java.util.HashMap;
import java.util.Map;

public enum ReportLevel {
    DEBUG(0),
    INFO(1),
    WARNING(2),
    VIOLATION(3),
    FAULT(4),
    CRITICAL_FAULT(5),
    DEVL_DEBUG(128),
    DEVL_INFO(129),
    DEVL_WARNING(130),
    DEVL_VIOLATION(131),
    DEVL_FAULT(132),
    DEVL_CRITICAL_FAULT(133);

    private static final Map<Integer, ReportLevel> idCache;
    private int id;

    private ReportLevel(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ReportLevel byId(int id) {
        if (idCache.isEmpty()) {
            ReportLevel.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ReportLevel with id " + id + " supported!");
        return ReportLevel.values()[0];
    }

    private static void buildCache() {
        for (ReportLevel each : ReportLevel.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ReportLevel>();
    }
}

