/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.immi;

import java.util.HashMap;
import java.util.Map;

public enum ImmiInputSignal {
    REJECT(0),
    MOULD_CLOSED(1),
    MOULD_OPEN_POSITION(2),
    INTERMEDIATE_MOULD_OPENING_POSITION(3),
    FUTURE_USE_RESERVED_ZC5(4),
    FUTURE_USE_RESERVED_ZC6(5),
    FUTURE_USE_RESERVED_ZC7(6),
    MANUFACTURER_DEPENDENT_ZC8(7),
    ENABLE_OPERATION_WITH_ROBOT(8),
    EJECTOR_BACK_POSITION(9),
    EJECTOR_FORWARD_POSITION(10),
    CORE_PULLERS_1_IN_POS_1(11),
    CORE_PULLERS_1_IN_POS_2(12),
    CORE_PULLERS_2_IN_POS_1(13),
    CORE_PULLERS_2_IN_POS_2(14),
    MOULDING_AREA_FREE_SIGNAL_ACTIVATED(15),
    ROBOT_EMERGENCY_STOPPED(16),
    EMERGENCY_STOP_MACHINE(17),
    SAFETY_DEVICES_OF_MACHINE(18),
    SUPPLY_FROM_ROBOT(19),
    MOULDING_MACHINE_24V_PRESENT(20);

    private static final Map<Integer, ImmiInputSignal> idCache;
    private int id;

    private ImmiInputSignal(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ImmiInputSignal byId(int id) {
        if (idCache.isEmpty()) {
            ImmiInputSignal.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ImmiInputSignal with id " + id + " supported!");
        return ImmiInputSignal.values()[0];
    }

    private static void buildCache() {
        for (ImmiInputSignal each : ImmiInputSignal.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ImmiInputSignal>();
    }
}

