/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.immi;

import java.util.HashMap;
import java.util.Map;

public enum ImmiOutputSignal {
    MANUFACTURER_DEPENDENT_A5(0),
    ENABLE_MOULD_CLOSURE(1),
    ENABLE_FULL_MOULD_OPENING(2),
    FUTURE_USE_RESERVED_A8(3),
    MANUFACTURER_DEPENDENT_C5(4),
    FUTURE_USE_RESERVED_C6(5),
    FUTURE_USE_RESERVED_C7(6),
    MANUFACTURER_DEPENDENT_C8(7),
    ROBOT_OPERATION_MODE(8),
    ENABLE_EJECTOR_BACK(9),
    ENABLE_EJECTOR_FORWARD(10),
    ENABLE_MOVE_CORE_PULLERS_1_TO_POS_1(11),
    ENABLE_MOVE_CORE_PULLERS_1_TO_POS_2(12),
    ENABLE_MOVE_CORE_PULLERS_2_TO_POS_1(13),
    ENABLE_MOVE_CORE_PULLERS_2_TO_POS_2(14),
    MOULD_AREA_FREE(15);

    private static final Map<Integer, ImmiOutputSignal> idCache;
    private int id;

    private ImmiOutputSignal(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ImmiOutputSignal byId(int id) {
        if (idCache.isEmpty()) {
            ImmiOutputSignal.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ImmiOutputSignal with id " + id + " supported!");
        return ImmiOutputSignal.values()[0];
    }

    private static void buildCache() {
        for (ImmiOutputSignal each : ImmiOutputSignal.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ImmiOutputSignal>();
    }
}

