/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.modbus;

import java.util.HashMap;
import java.util.Map;

public enum ModbusConnection {
    DISCONNECTED(-2),
    CONNECTING(-1),
    CONNECTION_OK(0),
    EXCEPTION_ILLEGAL_FUNCTION_CODE(1),
    EXCEPTION_ILLEGAL_DATA_ACCESS(2),
    EXCEPTION_ILLEGAL_DATA_VALUE(3),
    EXCEPTION_SERVER_FAILURE(4),
    EXCEPTION_ACKNOWLEDGE(5),
    EXCEPTION_SERVER_BUSY(6),
    EXCEPTION_GATEWAY_PROBLEM(10),
    EXCEPTION_GATEWAY_PROBLEM_TARGET_FAILURE(11);

    private static final Map<Integer, ModbusConnection> idCache;
    private int id;

    private ModbusConnection(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ModbusConnection byId(int id) {
        if (idCache.isEmpty()) {
            ModbusConnection.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ModbusConnection with id " + id + " supported!");
        return ModbusConnection.values()[0];
    }

    private static void buildCache() {
        for (ModbusConnection each : ModbusConnection.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ModbusConnection>();
    }
}

