/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.modbus;

import java.util.HashMap;
import java.util.Map;

public enum ModbusRunstate {
    PRESERVE_STATE(0),
    SET_LOW_AT_PROGRAM_STOP(1),
    SET_HIGH_AT_PROGRAM_STOP(2),
    REFLECT_PROGRAM_STATE(3),
    LOW_WHILE_ABORTED(4),
    REFLECT_ABORTED_STATE(5);

    private static final Map<Integer, ModbusRunstate> idCache;
    private int id;

    private ModbusRunstate(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ModbusRunstate byId(int id) {
        if (idCache.isEmpty()) {
            ModbusRunstate.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ModbusRunstate with id " + id + " supported!");
        return ModbusRunstate.values()[0];
    }

    private static void buildCache() {
        for (ModbusRunstate each : ModbusRunstate.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ModbusRunstate>();
    }
}

