/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.modbus;

import java.util.HashMap;
import java.util.Map;

public enum ModbusType {
    UNDEFINED(-1),
    DIGITAL_INPUT(0),
    DIGITAL_OUTPUT(1),
    REGISTER_INPUT(2),
    REGISTER_OUTPUT(3),
    MULTIPLE_DIGITAL_OUTPUT(15),
    MULTIPLE_REGISTER_OUTPUT(16),
    MULTIPLE_REGISTER_IO(23);

    private static final Map<Integer, ModbusType> idCache;
    private int id;

    private ModbusType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ModbusType byId(int id) {
        if (idCache.isEmpty()) {
            ModbusType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ModbusType with id " + id + " supported!");
        return ModbusType.values()[0];
    }

    private static void buildCache() {
        for (ModbusType each : ModbusType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ModbusType>();
    }
}

