/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.runtime;

import java.util.HashMap;
import java.util.Map;

public enum ControlMode {
    POSITION(0),
    TEACH(1),
    FORCE(2),
    TORQUE(3);

    private static final Map<Integer, ControlMode> idCache;
    private int id;

    private ControlMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ControlMode byId(int id) {
        if (idCache.isEmpty()) {
            ControlMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ControlMode with id " + id + " supported!");
        return ControlMode.values()[0];
    }

    private static void buildCache() {
        for (ControlMode each : ControlMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ControlMode>();
    }
}

