/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.runtime;

import java.util.HashMap;
import java.util.Map;

public enum PolyscopeFaultType {
    SAFETY_MISMATCH(2);

    private static final Map<Integer, PolyscopeFaultType> idCache;
    private int id;

    private PolyscopeFaultType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static PolyscopeFaultType byId(int id) {
        if (idCache.isEmpty()) {
            PolyscopeFaultType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No PolyscopeFaultType with id " + id + " supported!");
        return PolyscopeFaultType.values()[0];
    }

    private static void buildCache() {
        for (PolyscopeFaultType each : PolyscopeFaultType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, PolyscopeFaultType>();
    }
}

