/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.runtime;

import java.util.HashMap;
import java.util.Map;

public enum RuntimeVariableType {
    NONE(0),
    FUN(1),
    BUILTIN_FUN(2),
    CONST_STRING(3),
    VAR_STRING(4),
    STACK_REF(5),
    HEAP_REF(6),
    LOCAL_REF(7),
    VOID_REF(8),
    XMLRPC_INSTANCE(9),
    LINK_FRAME(10),
    THREAD(11),
    POSE(12),
    BOOL(13),
    NUM(14),
    INT(15),
    FLOAT(16),
    LIST(17),
    MATRIX(18),
    STRUCT(19),
    VAL_POINTER(20),
    ROS_SUB_INSTANCE(21),
    ROS_PUB_INSTANCE(22),
    ROS_SRV_CLIENT_INSTANCE(23),
    ROS_SRV_SERVER_INSTANCE(24),
    ROS_ACT_CLIENT_INSTANCE(25),
    ROS_ACT_SERVER_INSTANCE(26),
    ETHERNET_IP_INSTANCE(27);

    private static final Map<Integer, RuntimeVariableType> idCache;
    private int id;

    private RuntimeVariableType(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static RuntimeVariableType byId(int id) {
        if (idCache.isEmpty()) {
            RuntimeVariableType.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No RuntimeVariableType with id " + id + " supported!");
        return RuntimeVariableType.values()[0];
    }

    private static void buildCache() {
        for (RuntimeVariableType each : RuntimeVariableType.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, RuntimeVariableType>();
    }
}

