/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.runtime;

import java.util.HashMap;
import java.util.Map;

public enum SpeedMode {
    UNRESTRICTED(0),
    MANUAL_HIGH_SPEED(1),
    MANUAL_REDUCED_SPEED(2);

    private static final Map<Integer, SpeedMode> idCache;
    private int id;

    private SpeedMode(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static SpeedMode byId(int id) {
        if (idCache.isEmpty()) {
            SpeedMode.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No SpeedMode with id " + id + " supported!");
        return SpeedMode.values()[0];
    }

    private static void buildCache() {
        for (SpeedMode each : SpeedMode.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, SpeedMode>();
    }
}

