/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.safety;

import java.util.HashMap;
import java.util.Map;

public enum ToolSphere {
    UNDEFINED(0),
    DEFINED(1),
    DEFINED_AS_TOOL_FLANGE(2);

    private static final Map<Integer, ToolSphere> idCache;
    private int id;

    private ToolSphere(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static ToolSphere byId(int id) {
        if (idCache.isEmpty()) {
            ToolSphere.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No ToolSphere with id " + id + " supported!");
        return ToolSphere.values()[0];
    }

    private static void buildCache() {
        for (ToolSphere each : ToolSphere.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, ToolSphere>();
    }
}

