/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.toolcomm;

import java.util.HashMap;
import java.util.Map;

public enum BaudRate {
    BAUD_UNKNOWN(-1),
    BAUD_9600(9600),
    BAUD_19200(19200),
    BAUD_38400(38400),
    BAUD_57600(57600),
    BAUD_115200(115200),
    BAUD_1000000(1000000),
    BAUD_2000000(2000000),
    BAUD_5000000(5000000);

    private static final Map<Integer, BaudRate> idCache;
    private int id;

    private BaudRate(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static BaudRate byId(int id) {
        if (idCache.isEmpty()) {
            BaudRate.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No BaudRate with id " + id + " supported!");
        return BaudRate.values()[0];
    }

    private static void buildCache() {
        for (BaudRate each : BaudRate.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, BaudRate>();
    }
}

