/*
 * Decompiled with CFR 0.152.
 */
package com.ur.view.constants.toolcomm;

import java.util.HashMap;
import java.util.Map;

public enum Parity {
    UNKNOWN(-1),
    NONE(0),
    ODD(1),
    EVEN(2);

    private static final Map<Integer, Parity> idCache;
    private int id;

    private Parity(int id) {
        this.id = id;
    }

    public int getId() {
        return this.id;
    }

    public static Parity byId(int id) {
        if (idCache.isEmpty()) {
            Parity.buildCache();
        }
        if (idCache.containsKey(id)) {
            return idCache.get(id);
        }
        System.err.println("No Parity with id " + id + " supported!");
        return Parity.values()[0];
    }

    private static void buildCache() {
        for (Parity each : Parity.values()) {
            idCache.put(each.getId(), each);
        }
    }

    static {
        idCache = new HashMap<Integer, Parity>();
    }
}

