/*
 * Decompiled with CFR 0.152.
 */
package com.ur.boot.g5.internal;

import com.ur.boot.g5.internal.Log;
import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.packageadmin.ExportedPackage;
import org.osgi.service.packageadmin.PackageAdmin;

public class FindSplitPackages {
    private static boolean performValidation = true;
    private final Log logger;
    private final BundleContext bundleContext;
    private int totalNewlyDiscovered = 0;
    private Map<String, Bundle> packages = new HashMap<String, Bundle>();
    private static final List<String> SPLIT_PACKAGE_EXCEPTIONS = Collections.singletonList("com.ur.urcap.api.domain.value");

    public static void disableValidation() {
        performValidation = false;
    }

    public FindSplitPackages(Log logger, BundleContext bundleContext) {
        this.logger = logger;
        this.bundleContext = bundleContext;
    }

    public void print() throws BundleException {
        if (!performValidation) {
            return;
        }
        ServiceReference ref = this.bundleContext.getServiceReference(PackageAdmin.class.getName());
        PackageAdmin pa = (PackageAdmin)this.bundleContext.getService(ref);
        this.logger.log("Identifying Split Packages");
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!this.isURBundle(bundle)) continue;
            ExportedPackage[] exports = pa.getExportedPackages(bundle);
            this.validateExportedPackages(this.packages, bundle, exports);
        }
        if (this.totalNewlyDiscovered > 0) {
            throw new BundleException("New Split Packages found: " + this.totalNewlyDiscovered, 3);
        }
    }

    private void validateExportedPackages(Map<String, Bundle> packages, Bundle bundle, ExportedPackage[] exports) {
        if (exports == null) {
            return;
        }
        for (ExportedPackage each : exports) {
            if (!packages.containsKey(each.getName())) {
                packages.put(each.getName(), bundle);
                continue;
            }
            this.logSplitPackage(packages, bundle, each);
        }
    }

    private void logSplitPackage(Map<String, Bundle> packages, Bundle bundle, ExportedPackage each) {
        this.logger.log("Split package detected!\n  " + each + "\n  " + bundle + " " + bundle.getSymbolicName() + "\n  " + packages.get(each.getName()) + " " + packages.get(each.getName()).getSymbolicName());
        if (!SPLIT_PACKAGE_EXCEPTIONS.contains(each.getName())) {
            ++this.totalNewlyDiscovered;
        }
    }

    private boolean isURBundle(Bundle bundle) {
        return bundle.getSymbolicName() != null && !bundle.getSymbolicName().endsWith("boot-g5") && bundle.getSymbolicName().startsWith("com.ur.") && !bundle.getLocation().contains(File.separator + "urcaps" + File.separator) && !bundle.getSymbolicName().startsWith("com.ur.thirdparty");
    }
}

