/*
 * Decompiled with CFR 0.152.
 */
package com.ur.boot.g5.internal;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.service.log.LogService;

public class Log {
    private static final String LOG_TIME_FORMAT = "yyyyMMdd-HHmmss";
    private LogService logger;
    private Writer writer;

    public Log(BundleContext bundleContext) {
        ServiceReference ref = bundleContext.getServiceReference(LogService.class);
        this.logger = ref != null ? (LogService)bundleContext.getService(ref) : new EmptyLogService();
        try {
            this.writer = this.initFileLogging();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.writer = new EmptyWriter();
        }
    }

    private Writer initFileLogging() throws IOException {
        SimpleDateFormat df = new SimpleDateFormat(LOG_TIME_FORMAT);
        String logFilePrefix = "polyscope-startup-" + df.format(new Date()) + "-";
        File logFile = File.createTempFile(logFilePrefix, ".log");
        return new OutputStreamWriter((OutputStream)new FileOutputStream(logFile), "UTF-8");
    }

    public void log(String message) {
        this.logger.log(0, message);
        System.out.println(message);
        try {
            this.writer.write(message + "\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void stop() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class EmptyLogService
    implements LogService {
        private EmptyLogService() {
        }

        public void log(int i, String s) {
        }

        public void log(int i, String s, Throwable throwable) {
        }

        public void log(ServiceReference serviceReference, int i, String s) {
        }

        public void log(ServiceReference serviceReference, int i, String s, Throwable throwable) {
        }
    }

    private static class EmptyWriter
    extends Writer {
        private EmptyWriter() {
        }

        @Override
        public void write(char[] cbuf, int off, int len) throws IOException {
        }

        @Override
        public void flush() throws IOException {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

