/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program;

import com.ur.util.event.EventManager;
import com.ur.util.event.NotificationStrategy;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ProgramModeHolder {
    private final EventManager eventManager;
    private ProgramMode mode = ProgramMode.Unknown;

    @Inject
    public ProgramModeHolder(EventManager eventManager) {
        this.eventManager = eventManager;
    }

    public ProgramMode getMode() {
        return this.mode;
    }

    public void setMode(ProgramMode newMode) {
        if (newMode == this.mode && newMode != ProgramMode.Unknown) {
            return;
        }
        this.mode = newMode;
        this.eventManager.fireEvent(ProgramModeListener.class, (NotificationStrategy)new NotificationStrategy<ProgramModeListener>(){

            public void notify(ProgramModeListener listener) {
                listener.changedMode(ProgramModeHolder.this.mode);
            }
        });
    }

    public void setModeAndNotify(ProgramMode newMode) {
        this.mode = newMode;
        this.eventManager.fireEvent(ProgramModeListener.class, (NotificationStrategy)new NotificationStrategy<ProgramModeListener>(){

            public void notify(ProgramModeListener listener) {
                listener.changedMode(ProgramModeHolder.this.mode);
            }
        });
    }

    public static enum ProgramMode {
        Calibration,
        Editable,
        ReadOnly,
        Unknown;

    }

    public static interface ProgramModeListener {
        public void changedMode(ProgramMode var1);
    }
}

