/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.internal;

import com.ur.polyscope.program.cache.DefinedCache;
import com.ur.polyscope.program.internal.ProgramNodeDefinedCache;
import com.ur.polyscope.program.nodes.Undefineable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Singleton;

@Singleton
public class ProgramNodeDefinedCacheImpl
implements DefinedCache,
ProgramNodeDefinedCache {
    private boolean enabled;
    private final Map<Undefineable, Boolean> cacheMap = new HashMap<Undefineable, Boolean>();
    private final AtomicInteger refCount = new AtomicInteger();

    @Override
    public void enable() {
        this.enabled = true;
        this.refCount.incrementAndGet();
    }

    @Override
    public void disable() {
        if (!this.enabled) {
            return;
        }
        if (this.refCount.decrementAndGet() < 1) {
            this.enabled = false;
            this.cacheMap.clear();
            this.refCount.set(0);
        }
    }

    @Override
    public boolean isDefined(Undefineable programNode) {
        if (!this.enabled) {
            return !programNode.isUndefined();
        }
        Boolean cachedResult = this.cacheMap.get(programNode);
        if (cachedResult == null) {
            cachedResult = !programNode.isUndefined();
            this.cacheMap.put(programNode, cachedResult);
        }
        return cachedResult;
    }
}

