/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.internal;

import com.ur.injection.Binder;
import com.ur.injection.Builder;
import com.ur.injection.ChainingInterceptor;
import com.ur.injection.CompoundChangeInterceptor;
import com.ur.injection.DefaultTreeModelChangeInterceptor;
import com.ur.injection.IgnoreCallInterceptor;
import com.ur.injection.RemoveInterceptor;
import com.ur.injection.ServicesBinder;
import com.ur.injection.SetterInterceptor;
import com.ur.injection.SubstituteInterceptor;
import com.ur.injection.ThrowIfNonCompoundChangeInterceptor;
import com.ur.lang.ClassUtils;
import com.ur.polyscope.program.Program;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.program.ProgramTreeRenderingTriggerer;
import com.ur.polyscope.program.cache.DefinedCache;
import com.ur.polyscope.program.internal.ProgramNodeDefinedCache;
import com.ur.polyscope.program.internal.ProgramNodeDefinedCacheImpl;
import com.ur.polyscope.program.internal.UndoRedoManagerImpl;
import com.ur.polyscope.program.nodes.AbstractProgramNode;
import com.ur.polyscope.program.nodes.ProgramModel;
import com.ur.polyscope.program.nodes.URCapProgramNodeFactory;
import com.ur.polyscope.program.nodes.URCapProgramNodeFactoryStub;
import com.ur.polyscope.program.nodes.rules.AlwaysPossibleProgramNodeInsertionRule;
import com.ur.polyscope.program.nodes.rules.AlwaysPossibleProgramNodeRemovalRule;
import com.ur.polyscope.program.nodes.rules.ProgramNodeInsertionRule;
import com.ur.polyscope.program.nodes.rules.ProgramNodeRemovalRule;
import com.ur.polyscope.program.translations.TextResource;
import com.ur.polyscope.program.translations.impl.TextResourceImpl;
import com.ur.polyscope.program.undoredo.CompoundProgramChange;
import com.ur.polyscope.program.undoredo.DenyProgramChanges;
import com.ur.polyscope.program.undoredo.IgnoreProgramChanges;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeAspect;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeInterceptor;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramNodeRemoveProperty;
import com.ur.polyscope.program.undoredo.ProgramTreeChange;
import com.ur.polyscope.program.undoredo.ProgramTreeRenderingTriggererStub;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.program.undoredo.SkipWhenProgramIsLoadingAspect;
import com.ur.polyscope.program.undoredo.SkipWhenProgramIsLoadingInterceptor;
import com.ur.polyscope.program.undoredo.ThrowIfNonCompoundProgramChanges;
import com.ur.polyscope.program.undoredo.ThrowIfNonUIThread;
import com.ur.polyscope.program.undoredo.ThrowIfNonUIThreadInterceptor;
import com.ur.polyscope.program.undoredo.UndoRedoManager;
import com.ur.polyscope.program.undoredo.UndoRedoService;
import com.ur.reversible.ReversibleConsumer;
import com.ur.reversible.TreeNodeInsertRemove;
import java.lang.annotation.Annotation;
import java.util.Enumeration;
import javax.inject.Inject;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ServiceBinderImpl
implements ServicesBinder {
    public void bind(Binder binder) {
        binder.bindClassIfAbsent(UndoRedoManager.class, UndoRedoManagerImpl.class);
        binder.bindClassIfAbsent(ProgramTreeRenderingTriggerer.class, ProgramTreeRenderingTriggererStub.class);
        binder.bindClassIfAbsent(URCapProgramNodeFactory.class, URCapProgramNodeFactoryStub.class);
        SkipWhenProgramIsLoadingAspect.setInterceptor((MethodInterceptor)binder.injectWhenReady((Object)new SkipWhenProgramIsLoadingInterceptor()));
        ProgramEntitiesChangeAspect.setInterceptor((MethodInterceptor)binder.injectWhenReady((Object)new ProgramEntitiesChangeInterceptor()));
        MethodInterceptor programTreeChangeInterceptor = (MethodInterceptor)binder.injectWhenReady((Object)new ProgramTreeChangeInterceptor(ProgramTreeChange.class, null));
        MethodInterceptor programNodeChangeInterceptor = (MethodInterceptor)binder.injectWhenReady((Object)new ProgramNodeChangeInterceptor(ProgramNodeChange.class, programTreeChangeInterceptor));
        MethodInterceptor programNodeRemovePropertyInterceptor = (MethodInterceptor)binder.injectWhenReady((Object)new ProgramNodeRemovePropertyInterceptor(ProgramNodeRemoveProperty.class, programNodeChangeInterceptor));
        MethodInterceptor programSubstituteInterceptor = (MethodInterceptor)binder.injectWhenReady((Object)new ProgramSubstituteInterceptor(programNodeRemovePropertyInterceptor));
        MethodInterceptor compoundProgramChangeInterceptor = (MethodInterceptor)binder.injectWhenReady((Object)new ProgramCompoundChangeInterceptor(CompoundProgramChange.class, programSubstituteInterceptor));
        MethodInterceptor throwIfNonCompoundProgramChangeInterceptor = (MethodInterceptor)binder.injectWhenReady((Object)new ThrowIfNonCompoundProgramChangeInterceptor(ThrowIfNonCompoundProgramChanges.class, compoundProgramChangeInterceptor));
        ThrowIfNonUIInterceptor throwIfNonUIThreadInterceptor = new ThrowIfNonUIInterceptor(ThrowIfNonUIThread.class, throwIfNonCompoundProgramChangeInterceptor);
        IgnoreCallInterceptor programChangeInterceptor = new IgnoreCallInterceptor(IgnoreProgramChanges.class, (MethodInterceptor)throwIfNonUIThreadInterceptor);
        MethodInterceptor denyProgramChangesInterceptor = (MethodInterceptor)binder.injectWhenReady((Object)new DenyProgramChangesInterceptor((MethodInterceptor)programChangeInterceptor));
        ProgramUndoRedoAspect.setInterceptor(denyProgramChangesInterceptor);
        binder.bindClass(ProgramNodeDefinedCache.class, ProgramNodeDefinedCacheImpl.class);
        binder.bindClass(DefinedCache.class, ProgramNodeDefinedCacheImpl.class);
        binder.bindClass(TextResource.class, TextResourceImpl.class);
        binder.requestStaticBinding(AbstractProgramNode.class);
        binder.bindToExtensionPoint(ProgramNodeInsertionRule.class, AlwaysPossibleProgramNodeInsertionRule.class);
        binder.bindToExtensionPoint(ProgramNodeRemovalRule.class, AlwaysPossibleProgramNodeRemovalRule.class);
    }

    public void load(Builder builder) {
    }

    static class DenyProgramChangesInterceptor
    extends ChainingInterceptor {
        static ThreadLocal<Boolean> deny = new ThreadLocal<Boolean>(){

            @Override
            protected Boolean initialValue() {
                return false;
            }
        };
        static ThreadLocal<Exception> exception = new ThreadLocal<Exception>(){

            @Override
            protected Exception initialValue() {
                return null;
            }
        };

        public DenyProgramChangesInterceptor(MethodInterceptor next) {
            super(next);
        }

        public static boolean isDenied(String exceptionMessage) {
            Boolean denied = deny.get();
            if (denied.booleanValue()) {
                exception.set(new IllegalStateException(exceptionMessage));
            }
            return denied;
        }

        protected boolean shouldProcess(MethodInvocation methodInvocation) {
            return ClassUtils.hasAnnotation((Object)methodInvocation.getMethod(), DenyProgramChanges.class);
        }

        protected Object process(MethodInvocation methodInvocation) throws Throwable {
            this.throwIfHasException();
            try {
                deny.set(true);
                Object object = methodInvocation.proceed();
                return object;
            }
            finally {
                deny.set(false);
                this.throwIfHasException();
            }
        }

        private void throwIfHasException() throws Exception {
            Exception ex = exception.get();
            if (ex != null) {
                exception.set(null);
                throw ex;
            }
        }
    }

    static class ProgramCompoundChangeInterceptor
    extends CompoundChangeInterceptor<AbstractProgramNode> {
        public ProgramCompoundChangeInterceptor(Class<? extends Annotation> compoundChangeTag, MethodInterceptor next) {
            super(compoundChangeTag, next);
        }

        @Inject
        public void setUndoRedo(@Program UndoRedoService undoRedo) {
            this.setConsumer((ReversibleConsumer)undoRedo);
        }
    }

    static class ProgramNodeChangeInterceptor
    extends SetterInterceptor<AbstractProgramNode> {
        public ProgramNodeChangeInterceptor(Class<? extends Annotation> setterTag, MethodInterceptor next) {
            super(AbstractProgramNode.class, setterTag, next);
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (DenyProgramChangesInterceptor.isDenied("Program node changes denied")) {
                return null;
            }
            return super.invoke(invocation);
        }

        @Inject
        public void setUndoRedo(@Program UndoRedoService undoRedo) {
            this.setConsumer((ReversibleConsumer)undoRedo);
        }
    }

    static class ProgramNodeRemovePropertyInterceptor
    extends RemoveInterceptor<AbstractProgramNode> {
        public ProgramNodeRemovePropertyInterceptor(Class<? extends Annotation> removeTag, MethodInterceptor next) {
            super(AbstractProgramNode.class, removeTag, next);
        }

        @Inject
        public void setUndoRedo(@Program UndoRedoService undoRedo) {
            this.setConsumer((ReversibleConsumer)undoRedo);
        }
    }

    public static class ProgramSubstituteInterceptor
    extends SubstituteInterceptor<AbstractProgramNode> {
        public ProgramSubstituteInterceptor(MethodInterceptor next) {
            super(AbstractProgramNode.class, next);
        }

        @Inject
        public void setUndoRedo(@Program UndoRedoService undoRedo) {
            this.setConsumer((ReversibleConsumer)undoRedo);
        }
    }

    static class ProgramTreeChangeInterceptor
    extends DefaultTreeModelChangeInterceptor<AbstractProgramNode> {
        public ProgramTreeChangeInterceptor(Class<? extends Annotation> treeChangeTag, MethodInterceptor next) {
            super(AbstractProgramNode.class, treeChangeTag, next);
        }

        public Object invoke(MethodInvocation invocation) throws Throwable {
            if (DenyProgramChangesInterceptor.isDenied("Program tree changes denied")) {
                return null;
            }
            return super.invoke(invocation);
        }

        @Inject
        public void setUndoRedo(@Program UndoRedoService undoRedo) {
            this.setConsumer((ReversibleConsumer)undoRedo);
        }

        protected TreeNodeInsertRemove<AbstractProgramNode> makeReversible(DefaultTreeModel treeModel, AbstractProgramNode parent, AbstractProgramNode child, int index, boolean insertAction) {
            return new ProgramTreeNodeInsertRemove(treeModel, parent, child, index, insertAction);
        }
    }

    public static class ProgramTreeNodeInsertRemove
    extends TreeNodeInsertRemove<AbstractProgramNode> {
        public ProgramTreeNodeInsertRemove(DefaultTreeModel treeModel, AbstractProgramNode parent, AbstractProgramNode node, int index, boolean insertAction) {
            super(treeModel, (DefaultMutableTreeNode)parent, (DefaultMutableTreeNode)node, index, insertAction);
        }

        public AbstractProgramNode getChild() {
            return (AbstractProgramNode)this.child;
        }

        protected void insert() {
            super.insert();
            TreeNode root = ((AbstractProgramNode)this.parent).getRoot();
            if (root instanceof ProgramRootNode) {
                Enumeration<TreeNode> penum = ((AbstractProgramNode)this.child).breadthFirstEnumeration();
                while (penum.hasMoreElements()) {
                    DefaultMutableTreeNode each = (DefaultMutableTreeNode)penum.nextElement();
                    this.treeModel.nodeStructureChanged(each);
                    if (!(this.treeModel instanceof ProgramModel) || !(each instanceof AbstractProgramNode)) continue;
                    ((ProgramModel)((Object)this.treeModel)).makeVisible((AbstractProgramNode)each);
                }
            }
        }
    }

    static class ThrowIfNonCompoundProgramChangeInterceptor
    extends ThrowIfNonCompoundChangeInterceptor<AbstractProgramNode> {
        public ThrowIfNonCompoundProgramChangeInterceptor(Class<? extends Annotation> ignoreChangeTag, MethodInterceptor next) {
            super(ignoreChangeTag, next);
        }

        @Inject
        public void setUndoRedo(@Program UndoRedoService undoRedo) {
            this.setConsumer((ReversibleConsumer)undoRedo);
        }
    }

    static class ThrowIfNonUIInterceptor
    extends ThrowIfNonUIThreadInterceptor<AbstractProgramNode> {
        public ThrowIfNonUIInterceptor(Class<? extends Annotation> throwIfNonUIThreadTag, MethodInterceptor next) {
            super(throwIfNonUIThreadTag, next);
        }
    }
}

