/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.monitor;

import com.ur.monitor.StreamedModel;
import java.util.Collection;
import java.util.Collections;

public final class VariablesStateInfo
implements StreamedModel {
    private final Collection<VariableSnapshot> values;

    public VariablesStateInfo(Collection<VariableSnapshot> values) {
        this.values = Collections.unmodifiableCollection(values);
    }

    public Collection<VariableSnapshot> getValues() {
        return this.values;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VariablesStateInfo that = (VariablesStateInfo)o;
        return this.values.equals(that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    public String toString() {
        return "VariablesStateInfo{values=" + this.values + '}';
    }

    public static final class VariableSnapshot {
        private final String name;
        private final String value;

        public VariableSnapshot(String name, String value) {
            if (name == null || value == null) {
                throw new NullPointerException();
            }
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public String getValue() {
            return this.value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            VariableSnapshot that = (VariableSnapshot)o;
            if (!this.name.equals(that.name)) {
                return false;
            }
            return this.value.equals(that.value);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.value.hashCode();
            return result;
        }

        public String toString() {
            return "VariableSnapshot{name='" + this.name + '\'' + ", value='" + this.value + '\'' + '}';
        }
    }
}

