/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.nodes;

import com.google.common.collect.Sets;
import com.ur.lang.adt.Pair;
import com.ur.polyscope.program.PlaceholderOperationService;
import com.ur.polyscope.program.ProgramRootNode;
import com.ur.polyscope.program.internal.ProgramNodeDefinedCache;
import com.ur.polyscope.program.nodes.AbstractProgramNode$AjcClosure1;
import com.ur.polyscope.program.nodes.AbstractProgramNode$AjcClosure3;
import com.ur.polyscope.program.nodes.AbstractProgramNode$AjcClosure5;
import com.ur.polyscope.program.nodes.AbstractProgramNode$AjcClosure7;
import com.ur.polyscope.program.nodes.AbstractProgramNode$AjcClosure9;
import com.ur.polyscope.program.nodes.LockChildState;
import com.ur.polyscope.program.nodes.NextExecutionNode;
import com.ur.polyscope.program.nodes.ProgramModel;
import com.ur.polyscope.program.nodes.ProgramNode;
import com.ur.polyscope.program.nodes.ProgramNodeAncestorIterator;
import com.ur.polyscope.program.nodes.ProgramNodeTraversal;
import com.ur.polyscope.program.nodes.ProgramNodeType;
import com.ur.polyscope.program.nodes.ProgramNodeTypeImpl;
import com.ur.polyscope.program.nodes.ProgramNodeVisitor;
import com.ur.polyscope.program.nodes.ProgramSelectionModel;
import com.ur.polyscope.program.nodes.ScriptGeneratorProvider;
import com.ur.polyscope.program.nodes.Undefineable;
import com.ur.polyscope.program.translations.TextResource;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChange;
import com.ur.polyscope.program.undoredo.ProgramEntitiesChangeAspect;
import com.ur.polyscope.program.undoredo.ProgramNodeChange;
import com.ur.polyscope.program.undoredo.ProgramUndoRedoAspect;
import com.ur.polyscope.program.undoredo.SkipWhenProgramIsLoadingAspect;
import com.ur.polyscope.program.undoredo.SkipWhenProgramLoading;
import com.ur.polyscope.scriptwriter.ControllerInterfaceProgramNode;
import com.ur.polyscope.scriptwriter.ScriptError;
import com.ur.polyscope.scriptwriter.ScriptErrorGenerator;
import com.ur.polyscope.scriptwriter.ScriptGenerator;
import com.ur.polyscope.scriptwriter.ScriptGeneratorLookup;
import com.ur.polyscope.scriptwriter.ScriptWriter;
import com.ur.reference.Reference;
import com.ur.reference.ReferenceOwner;
import com.ur.swing.SwingUtil;
import com.ur.swing.aspects.interception.ProgressCounterAspect;
import com.ur.swing.taskprogress.counter.ProgressCounter;
import com.ur.util.CollectionUtils;
import com.ur.util.Optional;
import com.ur.util.Predicate;
import com.ur.util.logging.Log;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;

public abstract class AbstractProgramNode
extends DefaultMutableTreeNode
implements ScriptGenerator,
Cloneable,
ReferenceOwner,
ProgramNodeTraversal,
ControllerInterfaceProgramNode,
ProgramNode,
Undefineable {
    private static ProgramNodeDefinedCache programNodeDefinedCache;
    private static TextResource textResource;
    private static Provider<PlaceholderOperationService> placeholderOperationServiceProvider;
    public static final int UNDECORATED_NODE_ID = -1;
    private transient ScriptError scriptError = new ScriptError();
    private transient LinkedHashSet<AbstractProgramNode> prevExecutionProgramNodes = new LinkedHashSet();
    private transient LinkedHashSet<AbstractProgramNode> nextExecutionProgramNodes = new LinkedHashSet();
    private transient int id = -1;
    private transient boolean generateProgramLabel = true;
    private transient boolean isExecuting = false;
    private transient boolean unregisterProgramReferencesOnDelete = true;
    private transient AbstractProgramNode programRootNode;
    private transient LockChildState state = new LockChildState();
    private transient ProgramNodeType type;
    private String nodeTypeName;
    private String oldTreeTitle;
    Set<AbstractProgramNode> newNextSet;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;

    static {
        AbstractProgramNode.ajc$preClinit();
        programNodeDefinedCache = new ProgramNodeDefinedCache(){

            @Override
            public boolean isDefined(Undefineable programNode) {
                return !programNode.isUndefined();
            }
        };
    }

    public AbstractProgramNode() {
        this(new ProgramNodeTypeImpl(false, false));
    }

    @Inject
    public static void setTextResource(TextResource textResource) {
        AbstractProgramNode.textResource = textResource;
    }

    @Inject
    public static void setPlaceholderOperationServiceProvider(Provider<PlaceholderOperationService> placeholderOperationServiceProvider) {
        AbstractProgramNode.placeholderOperationServiceProvider = placeholderOperationServiceProvider;
    }

    @Inject
    private static void setProgramNodeDefinedCache(ProgramNodeDefinedCache programNodeDefinedCache) {
        AbstractProgramNode.programNodeDefinedCache = programNodeDefinedCache;
    }

    public AbstractProgramNode(ProgramNodeType type) {
        this.type = type;
        this.nodeTypeName = "Node";
    }

    public final String getTreeTitleWidthAutoAdjust() {
        String newTreeTitle = this.toString();
        if (!newTreeTitle.equals(this.oldTreeTitle)) {
            this.oldTreeTitle = newTreeTitle;
            ProgramModel programTreeModel = this.getProgramTreeModel();
            if (programTreeModel != null) {
                programTreeModel.nodeChanged(this);
            }
        }
        return this.oldTreeTitle;
    }

    protected void setNodeTypeName(String nodeTypeName) {
        this.nodeTypeName = nodeTypeName;
    }

    public static String indent(int level) {
        String s = "";
        while (level-- > 0) {
            s = String.valueOf(s) + "  ";
        }
        return s;
    }

    public boolean isDefined() {
        return programNodeDefinedCache.isDefined(this);
    }

    public LockChildState getState() {
        return this.state;
    }

    public void setState(LockChildState state) {
        this.state = new LockChildState(state);
    }

    public boolean isOfSort(ProgramNodeSort sort) {
        return false;
    }

    public boolean isUnregisterProgramReferencesOnDelete() {
        return this.unregisterProgramReferencesOnDelete;
    }

    @ProgramNodeChange
    public void setUnregisterProgramReferencesOnDelete(boolean unregisterProgramReferencesOnDelete) {
        boolean bl = unregisterProgramReferencesOnDelete;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)Conversions.booleanObject((boolean)bl));
        Object[] objectArray = new Object[]{this, Conversions.booleanObject((boolean)bl), joinPoint};
        AbstractProgramNode$AjcClosure1 abstractProgramNode$AjcClosure1 = new AbstractProgramNode$AjcClosure1(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(abstractProgramNode$AjcClosure1.linkClosureAndJoinPoint(69648));
    }

    public boolean canStartFromSelection() {
        return this.nullSafeCanChildrenStartFromSelection();
    }

    protected boolean canChildrenStartFromSelection() {
        return this.nullSafeCanChildrenStartFromSelection();
    }

    private boolean nullSafeCanChildrenStartFromSelection() {
        TreeNode parent = this.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof AbstractProgramNode) {
            return ((AbstractProgramNode)parent).canChildrenStartFromSelection();
        }
        return false;
    }

    public boolean canPauseOnNode() {
        return this.nullSafeCanChildrenPauseOnNode();
    }

    protected boolean canChildrenPauseOnNode() {
        return this.nullSafeCanChildrenPauseOnNode();
    }

    private boolean nullSafeCanChildrenPauseOnNode() {
        TreeNode parent = this.getParent();
        if (parent == null) {
            return true;
        }
        if (parent instanceof AbstractProgramNode) {
            return ((AbstractProgramNode)parent).canChildrenPauseOnNode();
        }
        return false;
    }

    public BreakpointType getBreakPointType() {
        return BreakpointType.breakBefore;
    }

    public String[] getLabelProperties() {
        BreakpointType bpType = this.getBreakPointType();
        if (!this.canPauseOnNode()) {
            bpType = BreakpointType.noBreak;
        }
        if (bpType == BreakpointType.breakBefore) {
            return null;
        }
        return new String[]{bpType.name()};
    }

    @Deprecated
    public ProgramNodeType getNodeType() {
        return this.type;
    }

    public ProgramNodeType getProgramNodeType() {
        return this.type;
    }

    @ProgramNodeChange
    public void setProgramNodeType(ProgramNodeType type) {
        ProgramNodeType programNodeType = type;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)this, (Object)this, (Object)programNodeType);
        Object[] objectArray = new Object[]{this, programNodeType, joinPoint};
        AbstractProgramNode$AjcClosure3 abstractProgramNode$AjcClosure3 = new AbstractProgramNode$AjcClosure3(objectArray);
        ProgramUndoRedoAspect.aspectOf().aroundAnnotatedMethod(abstractProgramNode$AjcClosure3.linkClosureAndJoinPoint(69648));
    }

    public boolean getGenerateProgramLabel() {
        return this.generateProgramLabel;
    }

    public void setGenerateProgramLabel(boolean generateProgramLabel) {
        this.generateProgramLabel = generateProgramLabel;
        if (this.getNodeType().isChildrenAllowed() && this.children != null) {
            for (AbstractProgramNode each : CollectionUtils.filter((Iterable)this.children, AbstractProgramNode.class)) {
                each.setGenerateProgramLabel(generateProgramLabel);
            }
        }
    }

    public ProgramModel getProgramTreeModel() {
        TreeNode root = this.getRoot();
        if (root instanceof ProgramRootNode) {
            return ((ProgramRootNode)((Object)root)).getComponent(ProgramModel.class);
        }
        return null;
    }

    @SkipWhenProgramLoading
    public void textHasChanged() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)this, (Object)this);
        Object[] objectArray = new Object[]{this, joinPoint};
        AbstractProgramNode$AjcClosure5 abstractProgramNode$AjcClosure5 = new AbstractProgramNode$AjcClosure5(objectArray);
        SkipWhenProgramIsLoadingAspect.aspectOf().aroundAnnotatedMethod(abstractProgramNode$AjcClosure5.linkClosureAndJoinPoint(69648));
    }

    public boolean isSuppressible() {
        return true;
    }

    public int getIndexBefore(AbstractProgramNode toInsert) {
        return this.getParent().getIndex(this);
    }

    public int getIndexAfter(AbstractProgramNode toInsert) {
        return this.getParent().getIndex(this) + 1;
    }

    public ScriptError getScriptError() {
        return this.scriptError;
    }

    public void setScriptError(ScriptWriter.ScriptPosition scriptPosition) {
        this.scriptError = new ScriptError(textResource.programNode(), this.toString());
        this.scriptError.addLabel(textResource.programNodeTypeRaw(), this.nodeTypeName);
        this.scriptError.addLabel(textResource.errorPosition(), textResource.linePosition(Integer.toString(this.getId())));
        this.markAsChanged();
    }

    public boolean hasScriptError() {
        return this.scriptError.hasError();
    }

    protected void markAsChanged() {
        ProgramModel programTreeModel = this.getProgramTreeModel();
        if (programTreeModel != null) {
            programTreeModel.nodeChanged(this);
        }
    }

    public void clearScriptError() {
        if (this.hasScriptError()) {
            this.scriptError.clear();
            this.markAsChanged();
        }
        if (this.children != null) {
            for (Object child : CollectionUtils.filter((Iterable)this.children, ScriptErrorGenerator.class)) {
                ((ScriptErrorGenerator)child).clearScriptError();
            }
        }
    }

    public boolean isExecuting() {
        return this.isExecuting;
    }

    public void setExecuting(boolean isExecuting) {
        this.isExecuting = isExecuting;
        if (this.parent instanceof AbstractProgramNode && ((AbstractProgramNode)this.parent).getNodeType().isChildrenAllowed()) {
            ((AbstractProgramNode)this.parent).setExecuting(isExecuting);
        }
    }

    public ScriptWriter generateLabeledChildren(ScriptWriter writer) {
        writer.writeProgramLabel((ControllerInterfaceProgramNode)this);
        if (this.getNodeType().isChildrenAllowed()) {
            writer.writeChildren((Iterable)this.children);
        }
        return writer;
    }

    @ProgressCounter
    public ScriptWriter generateScriptCode(ScriptWriter writer) {
        ScriptWriter scriptWriter = writer;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)this, (Object)this, (Object)scriptWriter);
        Object[] objectArray = new Object[]{this, scriptWriter, joinPoint};
        AbstractProgramNode$AjcClosure7 abstractProgramNode$AjcClosure7 = new AbstractProgramNode$AjcClosure7(objectArray);
        return (ScriptWriter)ProgressCounterAspect.aspectOf().aroundAnnotatedMethod(abstractProgramNode$AjcClosure7.linkClosureAndJoinPoint(69648));
    }

    protected boolean containsType(Class<?> type) {
        return this.getNodeOfType(type) != null;
    }

    public <T> T getNodeOfType(Class<T> ofType) {
        return this.getNodeType(ofType, Collections.singletonList(this));
    }

    private <T> T getNodeType(Class<T> ofType, List<AbstractProgramNode> newAncestors) {
        ProgramNodeAncestorIterator ancestorIterator = new ProgramNodeAncestorIterator(newAncestors);
        while (ancestorIterator.hasNext()) {
            AbstractProgramNode ancestor = ancestorIterator.next();
            if (!ofType.isInstance(ancestor)) continue;
            return (T)ancestor;
        }
        return null;
    }

    @Override
    public AbstractProgramNode clone() {
        AbstractProgramNode newNode = (AbstractProgramNode)super.clone();
        newNode.allowsChildren = this.allowsChildren;
        newNode.nextExecutionProgramNodes = new LinkedHashSet();
        newNode.prevExecutionProgramNodes = new LinkedHashSet();
        newNode.isExecuting = false;
        newNode.scriptError = new ScriptError();
        newNode.state = new LockChildState(this.state);
        newNode.type = new ProgramNodeTypeImpl(this.type.isChildrenAllowed(), this.type.isPlaceHolderRequired());
        if (this.children != null && this.getNodeType().isChildrenAllowed()) {
            for (AbstractProgramNode each : CollectionUtils.filter((Iterable)this.children, AbstractProgramNode.class)) {
                AbstractProgramNode newChild = each.clone();
                newNode.add(newChild);
            }
        }
        return newNode;
    }

    public AbstractProgramNode getProgramRoot() {
        return this.programRootNode;
    }

    public void setProgramRoot(AbstractProgramNode programRootNode) {
        this.programRootNode = programRootNode;
    }

    public boolean isNodeOrDescendantNodesMatching(Predicate<AbstractProgramNode> matchingPredicate, Predicate<AbstractProgramNode> filter) {
        if (matchingPredicate.test((Object)this)) {
            return true;
        }
        Enumeration<TreeNode> childrenEnumeration = this.children();
        while (childrenEnumeration.hasMoreElements()) {
            AbstractProgramNode child = (AbstractProgramNode)childrenEnumeration.nextElement();
            if (!filter.test((Object)child) || !child.isNodeOrDescendantNodesMatching(matchingPredicate, filter)) continue;
            return true;
        }
        return false;
    }

    @Override
    public <X> Set<X> getThisOrPreviousPositionNodes(Class<X> c) {
        return this.getThisOrPreviousPositionNodes(c, new HashSet<AbstractProgramNode>());
    }

    public <X> Set<Pair<Integer, X>> getThisOrPreviousPositionNodePairsNoWrapAround(Class<X> c) {
        return this.getThisOrPreviousPositionNodePairsNoWrapAround(c, new HashSet<AbstractProgramNode>());
    }

    @Override
    public <X> Set<X> getPreviousPositionNodes(Class<X> c) {
        Set<AbstractProgramNode> prevProgramNodes = this.getPrevExecutionProgramNodes();
        HashSet<X> positionNodes = new HashSet<X>();
        HashSet<AbstractProgramNode> visitedNodes = new HashSet<AbstractProgramNode>();
        for (AbstractProgramNode p : prevProgramNodes) {
            positionNodes.addAll(p.getThisOrPreviousPositionNodes(c, visitedNodes));
        }
        return positionNodes;
    }

    private <X> Set<X> getThisOrPreviousPositionNodes(Class<X> c, Set<AbstractProgramNode> visitedNodes) {
        if (visitedNodes.contains(this)) {
            return new HashSet();
        }
        visitedNodes.add(this);
        if (c.isAssignableFrom(this.getClass())) {
            HashSet<AbstractProgramNode> set = new HashSet<AbstractProgramNode>();
            set.add(this);
            return set;
        }
        Set<AbstractProgramNode> prevProgramNodes = this.getPrevExecutionProgramNodes();
        HashSet<X> positionNodes = new HashSet<X>();
        for (AbstractProgramNode p : prevProgramNodes) {
            positionNodes.addAll(p.getThisOrPreviousPositionNodes(c, visitedNodes));
        }
        return positionNodes;
    }

    private <X> Set<Pair<Integer, X>> getThisOrPreviousPositionNodePairsNoWrapAround(Class<X> c, Set<AbstractProgramNode> visitedNodes) {
        if (visitedNodes.contains(this)) {
            return new HashSet<Pair<Integer, X>>();
        }
        visitedNodes.add(this);
        if (c.isAssignableFrom(this.getClass())) {
            LinkedHashSet<Pair<Integer, X>> set = new LinkedHashSet<Pair<Integer, X>>();
            set.add(new Pair((Object)this.id, (Object)this));
            return set;
        }
        Set<AbstractProgramNode> prevProgramNodes = this.getPrevExecutionProgramNodesNoWrapAround();
        LinkedHashSet<Pair<Integer, X>> positionNodes = new LinkedHashSet<Pair<Integer, X>>();
        for (AbstractProgramNode p : prevProgramNodes) {
            positionNodes.addAll(p.getThisOrPreviousPositionNodePairsNoWrapAround(c, visitedNodes));
        }
        return positionNodes;
    }

    @Override
    public <X> Set<X> getNextPositionNodes(Class<X> c) {
        Set<AbstractProgramNode> nextProgramNodes = this.getNextExecutionProgramNodes();
        LinkedHashSet<X> positionNodes = new LinkedHashSet<X>();
        for (AbstractProgramNode p : nextProgramNodes) {
            Set<X> newNodes = p.getThisOrNextPositionNodes(c);
            positionNodes.addAll(newNodes);
        }
        return positionNodes;
    }

    @Override
    public <X> Set<X> getThisOrNextPositionNodes(Class<X> c) {
        if (this.nodeTypeExistsInTree(c)) {
            Set<Pair<Integer, X>> set = this.findNextExecutionNodesOfClass(c);
            LinkedHashSet<Object> result = new LinkedHashSet<Object>();
            for (Pair<Integer, X> each : set) {
                result.add(each.getSecond());
            }
            return result;
        }
        return new HashSet();
    }

    public <X> Set<Pair<Integer, X>> getThisOrNextPositionNodePair(Class<X> c) {
        if (this.nodeTypeExistsInTree(c)) {
            return this.findNextExecutionNodesOfClass(c);
        }
        return new HashSet<Pair<Integer, X>>();
    }

    private <X> Set<Pair<Integer, X>> findNextExecutionNodesOfClass(Class<X> c) {
        LinkedHashSet result = Sets.newLinkedHashSet();
        LinkedHashSet nextNodes = Sets.newLinkedHashSet();
        nextNodes.add(this);
        LinkedHashSet visitedNodes = Sets.newLinkedHashSet();
        boolean keepSearching = true;
        while (keepSearching) {
            Iterator it = nextNodes.iterator();
            this.newNextSet = new HashSet<AbstractProgramNode>();
            while (it.hasNext()) {
                AbstractProgramNode next = (AbstractProgramNode)it.next();
                visitedNodes.add(next);
                Optional<X> programNodeAsClass = next.getProgramNodeAsClass(c, next);
                if (programNodeAsClass.isPresent()) {
                    result.add(new Pair((Object)next.id, programNodeAsClass.get()));
                } else {
                    this.updateNextSet(visitedNodes, next);
                }
                it.remove();
            }
            if (this.newNextSet.isEmpty()) {
                keepSearching = false;
                continue;
            }
            nextNodes.addAll(this.newNextSet);
        }
        return result;
    }

    private void updateNextSet(Set<AbstractProgramNode> visitedNodes, AbstractProgramNode next) {
        for (AbstractProgramNode programNode : next.getNextExecutionProgramNodes()) {
            if (visitedNodes.contains(programNode)) continue;
            this.newNextSet.add(programNode);
        }
    }

    private boolean nodeTypeExistsInTree(Class<?> c) {
        Enumeration<TreeNode> it = this.breadthFirstEnumeration();
        while (it.hasMoreElements()) {
            TreeNode child = it.nextElement();
            if (!c.isAssignableFrom(child.getClass())) continue;
            return true;
        }
        return false;
    }

    protected <X> Optional<X> getProgramNodeAsClass(Class<X> c, AbstractProgramNode programNode) {
        if (c.isAssignableFrom(programNode.getClass())) {
            return Optional.of((Object)programNode);
        }
        return Optional.empty();
    }

    @Override
    public boolean isUndefined() {
        try {
            return this.getNodeType().isChildrenAllowed() && this.children != null && this.hasUndefinedChild();
        }
        catch (Exception e) {
            if (Log.canLog((Log.Level)Log.Level.ERROR)) {
                Log.error((String)"Failed during child.isUndefined() call", (Throwable)e);
            }
            return true;
        }
    }

    private boolean hasUndefinedChild() {
        for (Object each : this.children) {
            if (!(each instanceof AbstractProgramNode) || ((AbstractProgramNode)each).isDefined()) continue;
            if (Log.canLog((Log.Level)Log.Level.DEBUG)) {
                Log.debug((String)(String.valueOf(each.toString()) + ": is undefined in : " + this.toString()));
            }
            return true;
        }
        return false;
    }

    public void setSelected() {
        TreeNode root = this.getRoot();
        if (root instanceof ProgramRootNode) {
            ((ProgramRootNode)((Object)root)).getComponent(ProgramSelectionModel.class).setSelected(this);
        }
    }

    public LinkedHashSet<AbstractProgramNode> computeNodeToExecuteAfterCompletingThisChild(AbstractProgramNode child) {
        if (this.getNodeType().isChildrenAllowed()) {
            int nextIndex = this.getIndex(child) + 1;
            if (nextIndex < this.getChildCount()) {
                if (child instanceof NextExecutionNode) {
                    return ((NextExecutionNode)((Object)child)).getNodeToExecuteAfterThisBranch();
                }
                LinkedHashSet<AbstractProgramNode> ret = new LinkedHashSet<AbstractProgramNode>();
                ret.add((AbstractProgramNode)this.getChildAt(nextIndex));
                return ret;
            }
            AbstractProgramNode localParent = (AbstractProgramNode)this.getParent();
            if (localParent != null) {
                return localParent.computeNodeToExecuteAfterCompletingThisChild(this);
            }
            return new LinkedHashSet<AbstractProgramNode>();
        }
        return new LinkedHashSet<AbstractProgramNode>();
    }

    public void accept(ProgramNodeVisitor visitor) {
    }

    public LinkedHashSet<AbstractProgramNode> computeNextExecutionNodes() {
        if (this.getNodeType().isChildrenAllowed()) {
            LinkedHashSet<AbstractProgramNode> ret = new LinkedHashSet<AbstractProgramNode>();
            if (!this.isLeaf()) {
                AbstractProgramNode child = (AbstractProgramNode)this.getFirstChild();
                ret.add(child);
                return ret;
            }
            AbstractProgramNode localParent = (AbstractProgramNode)this.getParent();
            if (localParent != null) {
                return localParent.computeNodeToExecuteAfterCompletingThisChild(this);
            }
            return new LinkedHashSet<AbstractProgramNode>();
        }
        AbstractProgramNode localParent = (AbstractProgramNode)this.getParent();
        if (localParent != null) {
            return localParent.computeNodeToExecuteAfterCompletingThisChild(this);
        }
        return new LinkedHashSet<AbstractProgramNode>();
    }

    public void clearExecutionFlowGraph() {
        if (this.prevExecutionProgramNodes == null) {
            this.prevExecutionProgramNodes = new LinkedHashSet();
        } else {
            this.prevExecutionProgramNodes.clear();
        }
        if (this.nextExecutionProgramNodes == null) {
            this.nextExecutionProgramNodes = new LinkedHashSet();
        } else {
            this.nextExecutionProgramNodes.clear();
        }
    }

    public void setExecutionFlowGraph() {
        this.nextExecutionProgramNodes = this.computeNextExecutionNodes();
        for (AbstractProgramNode p : this.nextExecutionProgramNodes) {
            p.getPrevExecutionProgramNodes().add(this);
        }
    }

    public Set<AbstractProgramNode> getPrevExecutionProgramNodes() {
        return this.getAbstractProgramNodes();
    }

    protected Set<AbstractProgramNode> getPrevExecutionProgramNodesNoWrapAround() {
        return this.getAbstractProgramNodes();
    }

    private LinkedHashSet<AbstractProgramNode> getAbstractProgramNodes() {
        if (this.prevExecutionProgramNodes == null) {
            this.prevExecutionProgramNodes = new LinkedHashSet();
        }
        return this.prevExecutionProgramNodes;
    }

    public Set<AbstractProgramNode> getNextExecutionProgramNodes() {
        if (this.nextExecutionProgramNodes == null) {
            this.nextExecutionProgramNodes = new LinkedHashSet();
        }
        return this.nextExecutionProgramNodes;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public boolean isTreeExpandable() {
        return true;
    }

    public <T extends Collection<Object>> T getProgramEntitiesInSubtree(T collection) {
        Collection<Object> referenceEntities = this.getReferenceEntities(collection);
        Enumeration<TreeNode> childNodes = this.children();
        while (childNodes.hasMoreElements()) {
            TreeNode child = childNodes.nextElement();
            if (!(child instanceof AbstractProgramNode)) continue;
            ((AbstractProgramNode)child).getProgramEntitiesInSubtree(collection);
        }
        return (T)referenceEntities;
    }

    public Collection<Object> getReferenceEntities(Collection<Object> collection) {
        collection.add(this);
        this.getInternalProgramEntities(collection);
        return collection;
    }

    protected void getInternalProgramEntities(Collection<Object> collection) {
    }

    public int countNodes() {
        return this.countNodes(this);
    }

    private int countNodes(AbstractProgramNode node) {
        int count = 1;
        int nChildren = node.getChildCount();
        int i = 0;
        while (i < nChildren) {
            count += this.countNodes((AbstractProgramNode)node.getChildAt(i));
            ++i;
        }
        return count;
    }

    protected boolean doSubstituteReference(Object original, Object substitute) {
        return false;
    }

    public Object getNearestAncestorOfClass(Class<?> c) {
        TreeNode ancestor = null;
        TreeNode parentLocal = this.getParent();
        while (parentLocal != null) {
            if (c.isAssignableFrom(parentLocal.getClass())) {
                ancestor = parentLocal;
                break;
            }
            parentLocal = parentLocal.getParent();
        }
        return ancestor;
    }

    public void referenceStateChanged(Reference<?, ?> reference) {
        this.fireNodeChange();
    }

    public void substituteReference(Reference<?, ?> original, Reference<?, ?> substitute) {
        if (this.doSubstituteReferenceInSubtree(original, substitute)) {
            this.fireNodeChange();
        }
    }

    private boolean doSubstituteReferenceInSubtree(Reference<?, ?> original, Reference<?, ?> substitute) {
        boolean result = false;
        Enumeration<TreeNode> e = this.depthFirstEnumeration();
        while (e.hasMoreElements()) {
            TreeNode element = e.nextElement();
            if (!(element instanceof AbstractProgramNode)) continue;
            result |= ((AbstractProgramNode)element).doSubstituteReferenceAnnotated(original, substitute);
        }
        return result;
    }

    @ProgramEntitiesChange
    private final boolean doSubstituteReferenceAnnotated(Reference<?, ?> original, Reference<?, ?> substitute) {
        Reference<?, ?> reference = original;
        Reference<?, ?> reference2 = substitute;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)this, (Object)this, reference, reference2);
        Object[] objectArray = new Object[]{this, reference, reference2, joinPoint};
        AbstractProgramNode$AjcClosure9 abstractProgramNode$AjcClosure9 = new AbstractProgramNode$AjcClosure9(objectArray);
        return Conversions.booleanValue((Object)ProgramEntitiesChangeAspect.aspectOf().aroundAnnotatedMethod(abstractProgramNode$AjcClosure9.linkClosureAndJoinPoint(69648)));
    }

    private void fireNodeChange() {
        final ProgramModel programTreeModel = this.getProgramTreeModel();
        if (programTreeModel != null) {
            SwingUtil.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    programTreeModel.nodeChanged(AbstractProgramNode.this);
                }
            });
        }
    }

    public void scriptBegin(ScriptWriter scriptWriter) {
        if (this.programRootNode != null) {
            this.getScriptGenerator(this.programRootNode).markBeginScript((ScriptGenerator)this, scriptWriter);
        }
    }

    public void scriptEnd(ScriptWriter scriptWriter) {
        if (this.programRootNode != null) {
            this.getScriptGenerator(this.programRootNode).markEndScript((ScriptGenerator)this, scriptWriter);
        }
    }

    private ScriptGeneratorLookup getScriptGenerator(AbstractProgramNode rootNode) {
        return ((ScriptGeneratorProvider)((Object)rootNode)).getScriptGeneratorLookup();
    }

    @Override
    public ProgramNode.GenericProgramNode asGeneric() {
        return new ProgramNode.GenericProgramNode(this);
    }

    static final /* synthetic */ void setUnregisterProgramReferencesOnDelete_aroundBody0(AbstractProgramNode ajc$this, boolean unregisterProgramReferencesOnDelete, JoinPoint joinPoint) {
        ajc$this.unregisterProgramReferencesOnDelete = unregisterProgramReferencesOnDelete;
    }

    static final /* synthetic */ void setProgramNodeType_aroundBody2(AbstractProgramNode ajc$this, ProgramNodeType type, JoinPoint joinPoint) {
        ajc$this.type = type;
    }

    static final /* synthetic */ void textHasChanged_aroundBody4(AbstractProgramNode ajc$this, JoinPoint joinPoint) {
        SwingUtil.invokeAndWait((Runnable)ajc$this.new LoadInProgress());
    }

    static final /* synthetic */ ScriptWriter generateScriptCode_aroundBody6(AbstractProgramNode ajc$this, ScriptWriter writer, JoinPoint joinPoint) {
        ajc$this.scriptBegin(writer);
        ajc$this.generateLabeledChildren(writer);
        ajc$this.scriptEnd(writer);
        return writer;
    }

    static final /* synthetic */ boolean doSubstituteReferenceAnnotated_aroundBody8(AbstractProgramNode ajc$this, Reference original, Reference substitute, JoinPoint joinPoint) {
        return ajc$this.doSubstituteReference(original, substitute);
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("AbstractProgramNode.java", AbstractProgramNode.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setUnregisterProgramReferencesOnDelete", "com.ur.polyscope.program.nodes.AbstractProgramNode", "boolean", "unregisterProgramReferencesOnDelete", "", "void"), 158);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "setProgramNodeType", "com.ur.polyscope.program.nodes.AbstractProgramNode", "com.ur.polyscope.program.nodes.ProgramNodeType", "type", "", "void"), 232);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "textHasChanged", "com.ur.polyscope.program.nodes.AbstractProgramNode", "", "", "", "void"), 261);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "generateScriptCode", "com.ur.polyscope.program.nodes.AbstractProgramNode", "com.ur.polyscope.scriptwriter.ScriptWriter", "writer", "", "com.ur.polyscope.scriptwriter.ScriptWriter"), 344);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("12", "doSubstituteReferenceAnnotated", "com.ur.polyscope.program.nodes.AbstractProgramNode", "com.ur.reference.Reference:com.ur.reference.Reference", "original:substitute", "", "boolean"), 806);
    }

    public static enum BreakpointType {
        noBreak,
        breakBefore,
        breakAfter;

    }

    private class LoadInProgress
    implements Runnable {
        private LoadInProgress() {
        }

        @Override
        public void run() {
            ProgramModel ptm = AbstractProgramNode.this.getProgramTreeModel();
            if (ptm != null) {
                try {
                    try {
                        AbstractProgramNode node = this.getRootProgramNode();
                        ptm.nodeChanged(node);
                    }
                    catch (RuntimeException e) {
                        Log.error((String)"Failed notifying node change", (Throwable)e);
                        if (AbstractProgramNode.this.scriptError.hasError()) {
                            AbstractProgramNode.this.scriptError = new ScriptError();
                        }
                        try {
                            ptm.nodeChanged(AbstractProgramNode.this);
                        }
                        catch (RuntimeException e2) {
                            Log.error((String)"Failed notifying node change", (Throwable)e2);
                        }
                    }
                }
                finally {
                    if (AbstractProgramNode.this.scriptError.hasError()) {
                        AbstractProgramNode.this.scriptError = new ScriptError();
                    }
                    try {
                        ptm.nodeChanged(AbstractProgramNode.this);
                    }
                    catch (RuntimeException e) {
                        Log.error((String)"Failed notifying node change", (Throwable)e);
                    }
                }
            }
        }

        private AbstractProgramNode getRootProgramNode() {
            ProgramNodeAncestorIterator iterator = new ProgramNodeAncestorIterator(AbstractProgramNode.this);
            AbstractProgramNode rootProgramNode = AbstractProgramNode.this;
            while (iterator.hasNext()) {
                rootProgramNode = iterator.next();
            }
            return rootProgramNode;
        }
    }

    public static enum ProgramNodeSort {
        TOP_LEVEL,
        PRE_PROGRAM;

    }
}

