/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.nodes;

import java.util.Enumeration;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public interface ProgramNode {
    public GenericProgramNode asGeneric();

    public static class GenericProgramNode
    implements Iterable<GenericProgramNode> {
        private final DefaultMutableTreeNode nodeImpl;

        public GenericProgramNode(ProgramNode programNode) {
            this((Object)programNode);
        }

        private GenericProgramNode(Object nodeImpl) {
            if (!(nodeImpl instanceof DefaultMutableTreeNode)) {
                throw new IllegalStateException("Unknown type of program node: " + nodeImpl.getClass().getName());
            }
            this.nodeImpl = (DefaultMutableTreeNode)nodeImpl;
        }

        public String getName() {
            return this.nodeImpl.getClass().getSimpleName();
        }

        @Override
        public Iterator<GenericProgramNode> iterator() {
            final Enumeration<TreeNode> children = this.nodeImpl.children();
            return new Iterator<GenericProgramNode>(){

                @Override
                public boolean hasNext() {
                    return children.hasMoreElements();
                }

                @Override
                public GenericProgramNode next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    return ((ProgramNode)children.nextElement()).asGeneric();
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Children list cannot be changed");
                }
            };
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append(GenericProgramNode.indent(this.nodeImpl.getLevel())).append(" ").append(this.getName()).append("\n");
            for (GenericProgramNode node : this) {
                stringBuilder.append(node.toString());
            }
            return stringBuilder.toString();
        }

        private static String indent(int level) {
            StringBuilder indentBuilder = new StringBuilder();
            while (level > 0) {
                --level;
                indentBuilder.append("  ");
            }
            return indentBuilder.toString();
        }
    }
}

