/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.nodes;

import com.ur.polyscope.program.nodes.AbstractProgramNode;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

public class ProgramNodeAncestorIterator
implements Iterator<AbstractProgramNode> {
    private final ListIterator<AbstractProgramNode> newAncestorsIterator;
    private AbstractProgramNode currentAncestor = null;

    public ProgramNodeAncestorIterator(AbstractProgramNode ... nodes) {
        this(Arrays.asList(nodes));
    }

    public ProgramNodeAncestorIterator(List<AbstractProgramNode> newAncestors) {
        if (newAncestors == null) {
            newAncestors = Collections.emptyList();
        }
        this.newAncestorsIterator = newAncestors.listIterator(newAncestors.size());
    }

    @Override
    public boolean hasNext() {
        if (this.newAncestorsIterator.hasPrevious()) {
            return true;
        }
        return this.currentAncestor != null && this.currentAncestor.getParent() != null;
    }

    @Override
    public AbstractProgramNode next() {
        this.currentAncestor = this.newAncestorsIterator.hasPrevious() ? this.newAncestorsIterator.previous() : (AbstractProgramNode)this.currentAncestor.getParent();
        return this.currentAncestor;
    }

    @Override
    public void remove() {
        throw new NotImplemented("Removing ancestors is not allowed.");
    }

    public static class NotImplemented
    extends RuntimeException {
        public NotImplemented(String s) {
            super(s);
        }
    }
}

