/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.program.undoredo;

import com.google.inject.Inject;
import com.ur.exception.CustomUncaughtExceptionHandler;
import com.ur.injection.ChainingInterceptor;
import com.ur.lang.ClassUtils;
import com.ur.lang.StringUtils;
import java.lang.annotation.Annotation;
import javax.swing.SwingUtilities;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class ThrowIfNonUIThreadInterceptor<T>
extends ChainingInterceptor {
    private static final String MODIFICATION_OUTSIDE_UI_THREAD_MSG = "Modification of program tree and/or data model not allowed outside UI thread";
    private final Class<? extends Annotation> throwIfNonUIThreadTag;
    private CustomUncaughtExceptionHandler exceptionHandler = new NullUncaughtExceptionHandler();

    public ThrowIfNonUIThreadInterceptor(Class<? extends Annotation> throwIfNonUIThreadTag, MethodInterceptor next) {
        super(next);
        this.throwIfNonUIThreadTag = throwIfNonUIThreadTag;
    }

    @Inject(optional=true)
    public void setCustomExceptionHandler(CustomUncaughtExceptionHandler exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
    }

    protected boolean shouldProcess(MethodInvocation invocation) {
        return ThrowIfNonUIThreadInterceptor.isMethodAnnotatedWithTag(invocation, this.throwIfNonUIThreadTag);
    }

    private static boolean isMethodAnnotatedWithTag(MethodInvocation invocation, Class<? extends Annotation> throwIfNonUIThreadTag) {
        return ClassUtils.hasAnnotation((Object)invocation.getMethod(), throwIfNonUIThreadTag);
    }

    protected Object process(MethodInvocation invocation) throws Throwable {
        if (!ThrowIfNonUIThreadInterceptor.isUiOrEventThread()) {
            ThrowIfNonUIThreadInterceptor.throwException(this.getClassContext(), this.exceptionHandler);
        }
        return invocation.proceed();
    }

    private static void throwException(Class[] classes, CustomUncaughtExceptionHandler exceptionHandler) {
        IllegalStateException illegalStateException = new IllegalStateException(MODIFICATION_OUTSIDE_UI_THREAD_MSG);
        exceptionHandler.setStackTraceClassesForThrowable(classes, (Throwable)illegalStateException);
        throw illegalStateException;
    }

    private static boolean isUiOrEventThread() {
        return SwingUtilities.isEventDispatchThread() || StringUtils.equalsAny((String)Thread.currentThread().getName(), (String[])new String[]{"AWT-EventQueue-0", "AWT-EventQueue-1", "AWT-EventQueue-2", "Thread-0"});
    }

    private static class NullUncaughtExceptionHandler
    implements CustomUncaughtExceptionHandler {
        private NullUncaughtExceptionHandler() {
        }

        public void setStackTraceClassesForThrowable(Class[] classes, Throwable throwable) {
        }
    }
}

