/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.domain.PostSetInstallation;
import com.ur.polyscope.installation.domain.UnderWayInstallation;
import com.ur.polyscope.installation.domain.UnderwayInstallationProvider;
import com.ur.polyscope.installation.services.RobotInstallationSite;
import com.ur.util.event.EventNotificationService;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class UnderwayInstallationProviderImpl
implements UnderwayInstallationProvider,
UnderWayInstallation,
PostSetInstallation,
InstallationStateListener {
    private Installation robotInstallation;
    private final RobotInstallationSite robotInstallationSite;

    @Inject
    public UnderwayInstallationProviderImpl(RobotInstallationSite robotInstallationSite) {
        this.robotInstallationSite = robotInstallationSite;
        EventNotificationService.register((Object)this, InstallationStateListener.class, (Object)this);
    }

    public Installation getUnderwayInstallation() {
        return this.robotInstallation;
    }

    public void installationUnderWay(Installation robotInstallation) {
        this.robotInstallation = robotInstallation;
    }

    public void postLoad(Installation newInstallation) {
        this.robotInstallation = newInstallation;
    }

    public void installationModified() {
    }

    public void installationSaved() {
    }

    public void installationLoaded(Installation installation) {
    }

    public void installationLoadFailed() {
        this.resetToCurrentlyLoadedInstallation();
    }

    private void resetToCurrentlyLoadedInstallation() {
        this.robotInstallation = this.robotInstallationSite.getInstallation();
    }
}

