/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.aspect;

import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import javax.inject.Inject;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class InstallationChangeEventInterceptor
implements MethodInterceptor {
    private InstallationComponentLookup installationLookupService;

    @Inject
    void setRobotInstallationLookupService(InstallationComponentLookup installationLookupService) {
        this.installationLookupService = installationLookupService;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Object result = invocation.proceed();
        if (result == null) {
            this.fireInstallationChangedEvent();
        }
        if (this.isTrue(result)) {
            this.fireInstallationChangedEvent();
        }
        return result;
    }

    private boolean isTrue(Object result) {
        return result instanceof Boolean && (Boolean)result != false;
    }

    private void fireInstallationChangedEvent() {
        if (this.installationLookupService.hasInstallation()) {
            EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

                public void notify(InstallationStateListener listener) {
                    listener.installationModified();
                }
            });
        }
    }
}

