/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.impl;

import com.ur.polyscope.installation.Installation;
import com.ur.polyscope.installation.InstallationComponentLookup;
import com.ur.polyscope.installation.InstallationListener;
import com.ur.polyscope.installation.InstallationModifier;
import com.ur.polyscope.installation.InstallationStateListener;
import com.ur.polyscope.installation.loading.InstallationLoadingContext;
import com.ur.util.Waiting;
import com.ur.util.event.EventNotificationService;
import com.ur.util.event.NotificationStrategy;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class InstallationModifierImpl
implements InstallationModifier,
InstallationStateListener,
InstallationListener {
    private final InstallationComponentLookup installationLookupService;
    private InstallationLoadingContext installationLoadingContext;
    private boolean dirty = false;
    private boolean ready = false;

    @Inject
    public InstallationModifierImpl(InstallationComponentLookup installationLookupService, InstallationLoadingContext installationLoadingContext) {
        this.installationLookupService = installationLookupService;
        this.installationLoadingContext = installationLoadingContext;
        EventNotificationService.register((Object)this, InstallationStateListener.class, (Object)this);
        EventNotificationService.register((Object)this, InstallationListener.class, (Object)this);
    }

    public void makeDirty() {
        if (!this.dirty) {
            this.dirty = this.installationLoadingContext.isLoading() || !this.ready;
        }
    }

    public void installationModified() {
    }

    public void installationSaved() {
        this.dirty = false;
    }

    public void installationLoaded(Installation installation) {
        this.fireInstallationChangedEventAfterInstallationDone();
    }

    public void installationLoadFailed() {
        this.dirty = false;
    }

    private void fireInstallationChangedEventAfterInstallationDone() {
        new Thread(new Runnable(){

            @Override
            public void run() {
                InstallationModifierImpl.this.waitUntilPolyScopeInstallationReady();
                InstallationModifierImpl.this.waitUntilPolyScopeInstallationDone();
                InstallationModifierImpl.this.fireInstallationChangedEvent();
            }
        }).start();
    }

    private void waitUntilPolyScopeInstallationReady() {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return InstallationModifierImpl.this.ready;
            }
        }, (int)10, (TimeUnit)TimeUnit.MINUTES);
    }

    private void waitUntilPolyScopeInstallationDone() {
        Waiting.until((Waiting.ItHappens)new Waiting.ItHappens(){

            public boolean itHappened() {
                return !InstallationModifierImpl.this.installationLoadingContext.isLoading();
            }
        }, (int)30, (TimeUnit)TimeUnit.SECONDS);
    }

    private void fireInstallationChangedEvent() {
        if (this.installationLookupService.hasInstallation() && this.dirty && this.ready) {
            EventNotificationService.notify(InstallationStateListener.class, (NotificationStrategy)new NotificationStrategy<InstallationStateListener>(){

                public void notify(InstallationStateListener listener) {
                    listener.installationModified();
                }
            });
        }
        this.dirty = false;
    }

    public void onInstallationEvent(InstallationListener.Event event) {
        if (event.getType() == InstallationListener.EventType.INSTALLATION_READY) {
            this.ready = true;
        }
    }
}

