/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.impl.services;

import com.ur.lang.MapOfIdentityLists;
import com.ur.polyscope.installation.ShutdownHookService;
import com.ur.polyscope.java.logger.LogFactory;
import com.ur.polyscope.java.logger.Logger;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ShutdownHookServiceImpl
implements ShutdownHookService {
    private static final Logger LOG = LogFactory.createLogger(ShutdownHookServiceImpl.class);
    private MapOfIdentityLists stageToHooks = new MapOfIdentityLists();
    private Set<Runnable> runnables = new HashSet<Runnable>();

    @Inject
    public ShutdownHookServiceImpl() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                ShutdownHookServiceImpl.this.shutdown();
            }
        });
    }

    public void addShutdownHook(ShutdownHookService.Stage stage, Runnable runnable) {
        if (this.runnables.contains(runnable)) {
            throw new IllegalArgumentException("Hook previously registered");
        }
        this.runnables.add(runnable);
        this.stageToHooks.put((Object)stage, (Object)runnable);
    }

    void shutdown() {
        ShutdownHookService.Stage[] stageArray = ShutdownHookService.Stage.values();
        int n = stageArray.length;
        int n2 = 0;
        while (n2 < n) {
            ShutdownHookService.Stage stage = stageArray[n2];
            for (Object hook : this.stageToHooks.get((Object)stage)) {
                try {
                    ((Runnable)hook).run();
                }
                catch (Exception e) {
                    LOG.error("Shutdown hook failed to execute", (Throwable)e);
                }
            }
            ++n2;
        }
    }
}

