/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.resource;

import com.ur.polyscope.installation.resource.HasControl;
import com.ur.polyscope.installation.resource.ResourceControlRequest;
import com.ur.polyscope.installation.resource.ResourceControlStrategy;
import javax.inject.Provider;

public class RequestHandler
implements HasControl {
    private final Provider resourceProvider;
    private final ResourceControlRequest request;
    private final ResourceControlStrategy<Object, Object> strategy;
    private boolean control = false;
    private Object proxyResource;
    private Object proxyController;

    RequestHandler(Provider resourceProvider, ResourceControlRequest request, ResourceControlStrategy<Object, Object> strategy) {
        this.resourceProvider = resourceProvider;
        this.request = request;
        this.strategy = strategy;
        this.request.setHasControl((HasControl)this);
    }

    ResourceControlRequest getRequest() {
        return this.request;
    }

    private Object getProxyResource() {
        if (this.proxyResource == null) {
            Object realResource = this.resourceProvider.get();
            this.proxyResource = this.strategy.createResourceProxy(realResource, (HasControl)this);
        }
        return this.proxyResource;
    }

    private Object getProxyController() {
        if (this.proxyController == null) {
            this.proxyController = this.strategy.createControllerProxy(this.request);
        }
        return this.proxyController;
    }

    public boolean hasControl() {
        return this.control;
    }

    void onGrantControl() {
        this.control = true;
        this.strategy.onGrantControl(this.getProxyController(), this.getProxyResource());
    }

    void onRevokeControl() {
        this.strategy.onRevokeControl(this.getProxyController(), this.getProxyResource());
        this.control = false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.request);
        return sb.toString();
    }
}

