/*
 * Decompiled with CFR 0.152.
 */
package com.ur.polyscope.installation.internal.resource;

import com.ur.polyscope.installation.internal.resource.RequestHandler;
import com.ur.polyscope.installation.resource.ResourceControlRequest;
import com.ur.polyscope.installation.resource.ResourceControllerInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class RequestRegister {
    private final Map<String, Map<ResourceControlRequest, RequestHandler>> map = new HashMap<String, Map<ResourceControlRequest, RequestHandler>>();

    RequestRegister() {
    }

    RequestHandler getRequestHandler(ResourceControlRequest request) {
        Map<ResourceControlRequest, RequestHandler> resourceRequests = this.map.get(request.getResourceId());
        if (resourceRequests == null) {
            return null;
        }
        return resourceRequests.get(request);
    }

    boolean addRequestHandler(RequestHandler requestHandler) {
        ResourceControlRequest request;
        String resourceId = requestHandler.getRequest().getResourceId();
        Map<ResourceControlRequest, RequestHandler> resourceRequests = this.map.get(resourceId);
        if (resourceRequests == null) {
            resourceRequests = new LinkedHashMap<ResourceControlRequest, RequestHandler>();
            this.map.put(resourceId, resourceRequests);
        }
        if (!resourceRequests.containsKey(request = requestHandler.getRequest())) {
            resourceRequests.put(request, requestHandler);
            return true;
        }
        return false;
    }

    boolean removeRequestHandler(RequestHandler requestHandler) {
        String resourceId = requestHandler.getRequest().getResourceId();
        Map<ResourceControlRequest, RequestHandler> resourceRequests = this.map.get(resourceId);
        if (resourceRequests == null) {
            return false;
        }
        resourceRequests.remove(requestHandler.getRequest());
        return true;
    }

    List<ResourceControlRequest> getRequestsByResourceId(String resourceId) {
        ArrayList<ResourceControlRequest> list = new ArrayList<ResourceControlRequest>();
        Map<ResourceControlRequest, RequestHandler> resourceRequests = this.map.get(resourceId);
        if (resourceRequests != null) {
            for (RequestHandler ri : resourceRequests.values()) {
                list.add(ri.getRequest());
            }
        }
        return list;
    }

    List<ResourceControlRequest> getMissingRequestsByResourceControllerId(String resourceControllerId) {
        ArrayList<ResourceControlRequest> list = new ArrayList<ResourceControlRequest>();
        for (Map<ResourceControlRequest, RequestHandler> subMap : this.map.values()) {
            for (ResourceControlRequest request : subMap.keySet()) {
                ResourceControllerInfo controllerInfo = request.getResourceControllerInfo();
                if (!resourceControllerId.equals(controllerInfo.getId()) || !controllerInfo.isMissing()) continue;
                list.add(request);
            }
        }
        return list;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Requests{");
        for (Map.Entry<String, Map<ResourceControlRequest, RequestHandler>> entry : this.map.entrySet()) {
            String id = entry.getKey();
            sb.append(id).append("[");
            for (RequestHandler r : entry.getValue().values()) {
                sb.append(r).append(",");
            }
            sb.append("]");
        }
        sb.append("}");
        return sb.toString();
    }
}

